/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.system.impl;

import com.cisco.pt.UUID;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.impl.IPCObjectImpl;
import com.cisco.pt.ipc.system.CepInstance;
import com.cisco.pt.ipc.system.IPCManager;
import com.cisco.pt.ptmp.PacketTracerSession;

public class IPCManagerImpl
extends IPCObjectImpl
implements IPCManager {
    public IPCManagerImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    public int getListeningPort() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getListeningPort");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.getListeningPort");
        }
        return returnMessage.getIntValue();
    }

    public boolean launchCep(String cepId) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("launchCep");
        newCall.addStringParameter(cepId);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.launchCep");
        }
        return returnMessage.getBoolValue();
    }

    public boolean setExclusive(boolean exclusive) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setExclusive");
        newCall.addBoolParameter(exclusive);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.setExclusive");
        }
        return returnMessage.getBoolValue();
    }

    public boolean putSaveData(UUID saveId, String saveData) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("putSaveData");
        newCall.addUUIDParameter(saveId);
        newCall.addQStringParameter(saveData);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.putSaveData");
        }
        return returnMessage.getBoolValue();
    }

    public String getOpenData(UUID openId) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getOpenData");
        newCall.addUUIDParameter(openId);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (String)returnMessage.getObjectValue();
    }

    public CepInstance thisInstance() {
        return this.getFactory().thisInstance(this);
    }

    public boolean sendMessageTo(String cepId, String msg) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("sendMessageTo");
        newCall.addStringParameter(cepId);
        newCall.addQStringParameter(msg);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.sendMessageTo");
        }
        return returnMessage.getBoolValue();
    }

    public boolean sendMessageToInstance(UUID cepInstanceId, String msg) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("sendMessageToInstance");
        newCall.addUUIDParameter(cepInstanceId);
        newCall.addQStringParameter(msg);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.sendMessageToInstance");
        }
        return returnMessage.getBoolValue();
    }

    public boolean sendMessageToAll(String msg) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("sendMessageToAll");
        newCall.addQStringParameter(msg);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.sendMessageToAll");
        }
        return returnMessage.getBoolValue();
    }

    public boolean sendMessageToRemote(String cepId, String msg) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("sendMessageToRemote");
        newCall.addStringParameter(cepId);
        newCall.addQStringParameter(msg);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.sendMessageToRemote");
        }
        return returnMessage.getBoolValue();
    }

    public boolean sendMessageToRemoteInstance(UUID cepInstanceId, String msg) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("sendMessageToRemoteInstance");
        newCall.addUUIDParameter(cepInstanceId);
        newCall.addQStringParameter(msg);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: IPCManagerImpl.sendMessageToRemoteInstance");
        }
        return returnMessage.getBoolValue();
    }
}

